const Library = require("../Model/Library_Model");

const addToLibrary = async (req, res) => {
  try {
    let library = await Library.findOne({ user: req.userId });
    if (!library) {
      library = new Library({ user: req.userId, stories: [], series: [] });
    }

    const type = req.params.type; // 'story' or 'series'
    const itemId = req.params.id;
    const arrayField = type === 'story' ? 'stories' : 'series';
    
    const isInLibrary = library[arrayField].includes(itemId);
    if (isInLibrary) {
      library[arrayField] = library[arrayField].filter(id => id.toString() !== itemId);
    } else {
      library[arrayField].push(itemId);
    }

    await library.save();

    res.json({
      success: true,
      isAdded: !isInLibrary,
      message: !isInLibrary ? "Added to library" : "Removed from library"
    });
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

const getLibrary = async (req, res) => {
    try {
      const library = await Library.findOne({ user: req.userId })
        .populate({
          path: 'stories',
          populate: {
            path: 'author',
            select: 'username profileImage'
          }
        })
        .populate({
          path: 'series',
          populate: {
            path: 'author',
            select: 'username profileImage'
          }
        });
  
      res.json({
        success: true,
        library: library || { stories: [], series: [] }
      });
    } catch (error) {
      res.status(500).json({ error: error.message });
    }
  };
  

module.exports = {
  addToLibrary,
  getLibrary
};
