const Story = require("../Model/Story_Model");
const Series = require("../Model/Series_Model");

const searchContent = async (req, res) => {
  try {
    const { query } = req.query;

    if (!query || query.length < 2) {
      return res.status(200).json({ stories: [], series: [] });
    }

    const [stories, series] = await Promise.all([
      Story.find({
        $and: [
          { isPublished: true },
          {
            $or: [
              { title: { $regex: query, $options: "i" } },
              { summary: { $regex: query, $options: "i" } },
              { categories: { $regex: query, $options: "i" } },
            ],
          },
        ],
      })
        .populate("author", "username profileImage")
        .limit(5)
        .select("title summary categories coverImage reads likes reviews"),

      Series.find({
        $and: [
          { isPublished: true },
          {
            $or: [
              { title: { $regex: query, $options: "i" } },
              { summary: { $regex: query, $options: "i" } },
              { categories: { $regex: query, $options: "i" } },
            ],
          },
        ],
      })
        .populate("author", "username profileImage")
        .limit(5)
        .select("title summary categories coverImage episodes"),
    ]);

    res.status(200).json({
      stories: stories.map((story) => ({
        _id: story._id,
        title: story.title,
        type: "story",
        author: story.author,
        stats: {
          reads: story.reads || 0,
          likes: story.likes?.length || 0,
          reviews: story.reviews?.length || 0,
        },
      })),
      series: series.map((series) => ({
        _id: series._id,
        title: series.title,
        type: "series",
        author: series.author,
        stats: {
          episodes: series.episodes?.length || 0,
        },
      })),
    });
  } catch (error) {
    res
      .status(500)
      .json({ message: "Error performing search", error: error.message });
  }
};

module.exports = { searchContent };
