const mongoose = require("mongoose");

const categorySchema = new mongoose.Schema(
  {
    title: {
      type: String,
      required: true,
      trim: true,
      unique: true
    },
    coverImage: {
      type: String,
      default: ""
    },
    isActive: {
      type: Boolean,
      default: true
    },
    showOnHome: {
      type: Boolean,
      default: false
    },
    displayOrder: {
      type: Number,
      default: 999 // Default to a high number so new categories appear at the end
    },
    createdBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User"
    }
  },
  { timestamps: true }
);

module.exports = mongoose.model("Category", categorySchema);
