// models/UserTraffic.js
const mongoose = require('mongoose');

const userTrafficSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    default: null
  },
  username: {
    type: String,
    default: null
  },
  ipAddress: {
    type: String,
    required: true
  },
  userAgent: {
    type: String
  },
  entryTime: {
    type: Date,
    default: Date.now
  },
  exitTime: {
    type: Date,
    default: null
  },
  sessionId: {
    type: String,
    required: true
  }
});

module.exports = mongoose.model('UserTraffic', userTrafficSchema);
