const mongoose = require("mongoose");

const librarySchema = new mongoose.Schema(
  {
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    stories: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: "Story",
        required: true,
      },
    ],
    series: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: "Series",
        required: true,
      },
    ],
  },
  { timestamps: true }
);

module.exports = mongoose.model("Library", librarySchema);
