"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformInfoV2Reply = void 0;
const ADD_1 = __importDefault(require("./ADD"));
const CARD_1 = __importDefault(require("./CARD"));
const EXISTS_1 = __importDefault(require("./EXISTS"));
const INFO_1 = __importDefault(require("./INFO"));
const INSERT_1 = __importDefault(require("./INSERT"));
const LOADCHUNK_1 = __importDefault(require("./LOADCHUNK"));
const MADD_1 = __importDefault(require("./MADD"));
const MEXISTS_1 = __importDefault(require("./MEXISTS"));
const RESERVE_1 = __importDefault(require("./RESERVE"));
const SCANDUMP_1 = __importDefault(require("./SCANDUMP"));
const client_1 = require("@redis/client");
exports.default = {
    ADD: ADD_1.default,
    add: ADD_1.default,
    CARD: CARD_1.default,
    card: CARD_1.default,
    EXISTS: EXISTS_1.default,
    exists: EXISTS_1.default,
    INFO: INFO_1.default,
    info: INFO_1.default,
    INSERT: INSERT_1.default,
    insert: INSERT_1.default,
    LOADCHUNK: LOADCHUNK_1.default,
    loadChunk: LOADCHUNK_1.default,
    MADD: MADD_1.default,
    mAdd: MADD_1.default,
    MEXISTS: MEXISTS_1.default,
    mExists: MEXISTS_1.default,
    RESERVE: RESERVE_1.default,
    reserve: RESERVE_1.default,
    SCANDUMP: SCANDUMP_1.default,
    scanDump: SCANDUMP_1.default
};
function transformInfoV2Reply(reply, typeMapping) {
    const mapType = typeMapping ? typeMapping[client_1.RESP_TYPES.MAP] : undefined;
    switch (mapType) {
        case Array: {
            return reply;
        }
        case Map: {
            const ret = new Map();
            for (let i = 0; i < reply.length; i += 2) {
                ret.set(reply[i].toString(), reply[i + 1]);
            }
            return ret;
        }
        default: {
            const ret = Object.create(null);
            for (let i = 0; i < reply.length; i += 2) {
                ret[reply[i].toString()] = reply[i + 1];
            }
            return ret;
        }
    }
}
exports.transformInfoV2Reply = transformInfoV2Reply;
//# sourceMappingURL=index.js.map