"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformByRankArguments = void 0;
const generic_transformers_1 = require("@redis/client/dist/lib/commands/generic-transformers");
function transformByRankArguments(parser, key, ranks) {
    parser.pushKey(key);
    for (const rank of ranks) {
        parser.push(rank.toString());
    }
}
exports.transformByRankArguments = transformByRankArguments;
exports.default = {
    IS_READ_ONLY: true,
    parseCommand(...args) {
        args[0].push('TDIGEST.BYRANK');
        transformByRankArguments(...args);
    },
    transformReply: generic_transformers_1.transformDoubleArrayReply
};
//# sourceMappingURL=BYRANK.js.map