"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const generic_transformers_1 = require("./generic-transformers");
exports.default = {
    IS_READ_ONLY: false,
    parseCommand(parser, key, group, consumer, minIdleTime, id, options) {
        parser.push('XCLAIM');
        parser.pushKey(key);
        parser.push(group, consumer, minIdleTime.toString());
        parser.pushVariadic(id);
        if (options?.IDLE !== undefined) {
            parser.push('IDLE', options.IDLE.toString());
        }
        if (options?.TIME !== undefined) {
            parser.push('TIME', (options.TIME instanceof Date ? options.TIME.getTime() : options.TIME).toString());
        }
        if (options?.RETRYCOUNT !== undefined) {
            parser.push('RETRYCOUNT', options.RETRYCOUNT.toString());
        }
        if (options?.FORCE) {
            parser.push('FORCE');
        }
        if (options?.LASTID !== undefined) {
            parser.push('LASTID', options.LASTID);
        }
    },
    transformReply(reply, preserve, typeMapping) {
        return reply.map(generic_transformers_1.transformStreamMessageNullReply.bind(undefined, typeMapping));
    }
};
//# sourceMappingURL=XCLAIM.js.map