"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    CACHEABLE: true,
    IS_READ_ONLY: true,
    parseCommand(parser, key, group) {
        parser.push('XPENDING');
        parser.pushKey(key);
        parser.push(group);
    },
    transformReply(reply) {
        const consumers = reply[3];
        return {
            pending: reply[0],
            firstId: reply[1],
            lastId: reply[2],
            consumers: consumers === null ? null : consumers.map(consumer => {
                const [name, deliveriesCounter] = consumer;
                return {
                    name,
                    deliveriesCounter: Number(deliveriesCounter)
                };
            })
        };
    }
};
//# sourceMappingURL=XPENDING.js.map