"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    CACHEABLE: true,
    IS_READ_ONLY: true,
    parseCommand(parser, key, group, start, end, count, options) {
        parser.push('XPENDING');
        parser.pushKey(key);
        parser.push(group);
        if (options?.IDLE !== undefined) {
            parser.push('IDLE', options.IDLE.toString());
        }
        parser.push(start, end, count.toString());
        if (options?.consumer) {
            parser.push(options.consumer);
        }
    },
    transformReply(reply) {
        return reply.map(pending => {
            const unwrapped = pending;
            return {
                id: unwrapped[0],
                consumer: unwrapped[1],
                millisecondsSinceLastDelivery: unwrapped[2],
                deliveriesCounter: unwrapped[3]
            };
        });
    }
};
//# sourceMappingURL=XPENDING_RANGE.js.map