"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ZADD_1 = require("./ZADD");
const generic_transformers_1 = require("./generic-transformers");
exports.default = {
    parseCommand(parser, key, members, options) {
        parser.push('ZADD');
        parser.pushKey(key);
        if (options?.condition) {
            parser.push(options.condition);
        }
        if (options?.comparison) {
            parser.push(options.comparison);
        }
        if (options?.CH) {
            parser.push('CH');
        }
        parser.push('INCR');
        (0, ZADD_1.pushMembers)(parser, members);
    },
    transformReply: generic_transformers_1.transformNullableDoubleReply
};
//# sourceMappingURL=ZADD_INCR.js.map