"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TIME_SERIES_AGGREGATION_TYPE = void 0;
exports.TIME_SERIES_AGGREGATION_TYPE = {
    AVG: 'AVG',
    FIRST: 'FIRST',
    LAST: 'LAST',
    MIN: 'MIN',
    MAX: 'MAX',
    SUM: 'SUM',
    RANGE: 'RANGE',
    COUNT: 'COUNT',
    STD_P: 'STD.P',
    STD_S: 'STD.S',
    VAR_P: 'VAR.P',
    VAR_S: 'VAR.S',
    TWA: 'TWA'
};
exports.default = {
    IS_READ_ONLY: false,
    parseCommand(parser, sourceKey, destinationKey, aggregationType, bucketDuration, alignTimestamp) {
        parser.push('TS.CREATERULE');
        parser.pushKeys([sourceKey, destinationKey]);
        parser.push('AGGREGATION', aggregationType, bucketDuration.toString());
        if (alignTimestamp !== undefined) {
            parser.push(alignTimestamp.toString());
        }
    },
    transformReply: undefined
};
//# sourceMappingURL=CREATERULE.js.map