"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseIncrByArguments = void 0;
const _1 = require(".");
function parseIncrByArguments(parser, key, value, options) {
    parser.pushKey(key);
    parser.push(value.toString());
    if (options?.TIMESTAMP !== undefined && options?.TIMESTAMP !== null) {
        parser.push('TIMESTAMP', (0, _1.transformTimestampArgument)(options.TIMESTAMP));
    }
    (0, _1.parseRetentionArgument)(parser, options?.RETENTION);
    if (options?.UNCOMPRESSED) {
        parser.push('UNCOMPRESSED');
    }
    (0, _1.parseChunkSizeArgument)(parser, options?.CHUNK_SIZE);
    (0, _1.parseLabelsArgument)(parser, options?.LABELS);
    (0, _1.parseIgnoreArgument)(parser, options?.IGNORE);
}
exports.parseIncrByArguments = parseIncrByArguments;
exports.default = {
    IS_READ_ONLY: false,
    parseCommand(...args) {
        const parser = args[0];
        parser.push('TS.INCRBY');
        parseIncrByArguments(...args);
    },
    transformReply: undefined
};
//# sourceMappingURL=INCRBY.js.map