"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTransformMRangeArguments = void 0;
const _1 = require(".");
const RANGE_1 = require("./RANGE");
const MGET_1 = require("./MGET");
function createTransformMRangeArguments(command) {
    return (parser, fromTimestamp, toTimestamp, filter, options) => {
        parser.push(command);
        (0, RANGE_1.parseRangeArguments)(parser, fromTimestamp, toTimestamp, options);
        (0, MGET_1.parseFilterArgument)(parser, filter);
    };
}
exports.createTransformMRangeArguments = createTransformMRangeArguments;
exports.default = {
    NOT_KEYED_COMMAND: true,
    IS_READ_ONLY: true,
    parseCommand: createTransformMRangeArguments('TS.MRANGE'),
    transformReply: {
        2(reply, _, typeMapping) {
            return (0, _1.resp2MapToValue)(reply, ([_key, _labels, samples]) => {
                return _1.transformSamplesReply[2](samples);
            }, typeMapping);
        },
        3(reply) {
            return (0, _1.resp3MapToValue)(reply, ([_labels, _metadata, samples]) => {
                return _1.transformSamplesReply[3](samples);
            });
        }
    },
};
//# sourceMappingURL=MRANGE.js.map