"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMRangeWithLabelsGroupByTransformArguments = void 0;
const _1 = require(".");
const RANGE_1 = require("./RANGE");
const MRANGE_GROUPBY_1 = require("./MRANGE_GROUPBY");
const MGET_1 = require("./MGET");
function createMRangeWithLabelsGroupByTransformArguments(command) {
    return (parser, fromTimestamp, toTimestamp, filter, groupBy, options) => {
        parser.push(command);
        (0, RANGE_1.parseRangeArguments)(parser, fromTimestamp, toTimestamp, options);
        parser.push('WITHLABELS');
        (0, MGET_1.parseFilterArgument)(parser, filter);
        (0, MRANGE_GROUPBY_1.parseGroupByArguments)(parser, groupBy);
    };
}
exports.createMRangeWithLabelsGroupByTransformArguments = createMRangeWithLabelsGroupByTransformArguments;
exports.default = {
    IS_READ_ONLY: true,
    parseCommand: createMRangeWithLabelsGroupByTransformArguments('TS.MRANGE'),
    transformReply: {
        2(reply, _, typeMapping) {
            return (0, _1.resp2MapToValue)(reply, ([_key, labels, samples]) => {
                const transformed = (0, _1.transformRESP2LabelsWithSources)(labels);
                return {
                    labels: transformed.labels,
                    sources: transformed.sources,
                    samples: _1.transformSamplesReply[2](samples)
                };
            }, typeMapping);
        },
        3(reply) {
            return (0, _1.resp3MapToValue)(reply, ([labels, _metadata, metadata2, samples]) => {
                return {
                    labels,
                    sources: (0, MRANGE_GROUPBY_1.extractResp3MRangeSources)(metadata2),
                    samples: _1.transformSamplesReply[3](samples)
                };
            });
        }
    },
};
//# sourceMappingURL=MRANGE_WITHLABELS_GROUPBY.js.map