/// <reference types="node" />
import type { DoubleReply, NumberReply, TuplesReply, UnwrapReply, Resp2Reply, ArrayReply, BlobStringReply, MapReply, NullReply, TypeMapping, ReplyUnion, RespType } from '@redis/client/dist/lib/RESP/types';
import { TsIgnoreOptions } from './ADD';
import { RedisVariadicArgument } from '@redis/client/dist/lib/commands/generic-transformers';
import { CommandParser } from '@redis/client/dist/lib/client/parser';
declare const _default: {
    readonly ADD: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, timestamp: Timestamp, value: number, options?: import("./ADD").TsAddOptions | undefined) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly add: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, timestamp: Timestamp, value: number, options?: import("./ADD").TsAddOptions | undefined) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly ALTER: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./ALTER").TsAlterOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly alter: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./ALTER").TsAlterOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly CREATE: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./CREATE").TsCreateOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly create: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./CREATE").TsCreateOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly CREATERULE: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, sourceKey: import("@redis/client/dist/lib/RESP/types").RedisArgument, destinationKey: import("@redis/client/dist/lib/RESP/types").RedisArgument, aggregationType: import("./CREATERULE").TimeSeriesAggregationType, bucketDuration: number, alignTimestamp?: number | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly createRule: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, sourceKey: import("@redis/client/dist/lib/RESP/types").RedisArgument, destinationKey: import("@redis/client/dist/lib/RESP/types").RedisArgument, aggregationType: import("./CREATERULE").TimeSeriesAggregationType, bucketDuration: number, alignTimestamp?: number | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly DECRBY: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, value: number, options?: import("./INCRBY").TsIncrByOptions | undefined) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly decrBy: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, value: number, options?: import("./INCRBY").TsIncrByOptions | undefined) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly DEL: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, fromTimestamp: Timestamp, toTimestamp: Timestamp) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly del: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, fromTimestamp: Timestamp, toTimestamp: Timestamp) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly DELETERULE: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, sourceKey: import("@redis/client/dist/lib/RESP/types").RedisArgument, destinationKey: import("@redis/client/dist/lib/RESP/types").RedisArgument) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly deleteRule: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, sourceKey: import("@redis/client/dist/lib/RESP/types").RedisArgument, destinationKey: import("@redis/client/dist/lib/RESP/types").RedisArgument) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    readonly GET: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./GET").TsGetOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: UnwrapReply<Resp2Reply<import("./GET").TsGetReply>>) => {
                timestamp: NumberReply<number>;
                value: number;
            } | null;
            readonly 3: (this: void, reply: UnwrapReply<import("./GET").TsGetReply>) => {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            } | null;
        };
    };
    readonly get: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./GET").TsGetOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: UnwrapReply<Resp2Reply<import("./GET").TsGetReply>>) => {
                timestamp: NumberReply<number>;
                value: number;
            } | null;
            readonly 3: (this: void, reply: UnwrapReply<import("./GET").TsGetReply>) => {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            } | null;
        };
    };
    readonly INCRBY: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, value: number, options?: import("./INCRBY").TsIncrByOptions | undefined) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly incrBy: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, value: number, options?: import("./INCRBY").TsIncrByOptions | undefined) => void;
        readonly transformReply: () => NumberReply<number>;
    };
    readonly INFO_DEBUG: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: string) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: [...import("./INFO").InfoRawReplyTypes[], "keySelfName", BlobStringReply<string>, "Chunks", ["startTimestamp", NumberReply<number>, "endTimestamp", NumberReply<number>, "samples", NumberReply<number>, "size", NumberReply<number>, "bytesPerSample", import("@redis/client/dist/lib/RESP/types").SimpleStringReply<string>][]], _: any, typeMapping?: TypeMapping | undefined) => import("./INFO_DEBUG").InfoDebugReply;
            readonly 3: () => ReplyUnion;
        };
        readonly unstableResp3: true;
    };
    readonly infoDebug: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: string) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: [...import("./INFO").InfoRawReplyTypes[], "keySelfName", BlobStringReply<string>, "Chunks", ["startTimestamp", NumberReply<number>, "endTimestamp", NumberReply<number>, "samples", NumberReply<number>, "size", NumberReply<number>, "bytesPerSample", import("@redis/client/dist/lib/RESP/types").SimpleStringReply<string>][]], _: any, typeMapping?: TypeMapping | undefined) => import("./INFO_DEBUG").InfoDebugReply;
            readonly 3: () => ReplyUnion;
        };
        readonly unstableResp3: true;
    };
    readonly INFO: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: string) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./INFO").InfoRawReply, _: any, typeMapping?: TypeMapping | undefined) => import("./INFO").InfoReply;
            readonly 3: () => ReplyUnion;
        };
        readonly unstableResp3: true;
    };
    readonly info: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: string) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./INFO").InfoRawReply, _: any, typeMapping?: TypeMapping | undefined) => import("./INFO").InfoReply;
            readonly 3: () => ReplyUnion;
        };
        readonly unstableResp3: true;
    };
    readonly MADD: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, toAdd: import("./MADD").TsMAddSample[]) => void;
        readonly transformReply: () => ArrayReply<NumberReply<number> | import("@redis/client/dist/lib/RESP/types").SimpleErrorReply>;
    };
    readonly mAdd: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: CommandParser, toAdd: import("./MADD").TsMAddSample[]) => void;
        readonly transformReply: () => ArrayReply<NumberReply<number> | import("@redis/client/dist/lib/RESP/types").SimpleErrorReply>;
    };
    readonly MGET_SELECTED_LABELS: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument, selectedLabels: RedisVariadicArgument, options?: import("./MGET").TsMGetOptions | undefined) => void;
        readonly transformReply: {
            2(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply2<BlobStringReply<string> | NullReply>, _: any, typeMapping?: TypeMapping | undefined): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string> | NullReply>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: number;
                };
            }>;
            3(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply3<BlobStringReply<string> | NullReply>): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string> | NullReply>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                };
            }>;
        };
    };
    readonly mGetSelectedLabels: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument, selectedLabels: RedisVariadicArgument, options?: import("./MGET").TsMGetOptions | undefined) => void;
        readonly transformReply: {
            2(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply2<BlobStringReply<string> | NullReply>, _: any, typeMapping?: TypeMapping | undefined): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string> | NullReply>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: number;
                };
            }>;
            3(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply3<BlobStringReply<string> | NullReply>): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string> | NullReply>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                };
            }>;
        };
    };
    readonly MGET_WITHLABELS: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument, options?: import("./MGET_WITHLABELS").TsMGetWithLabelsOptions | undefined) => void;
        readonly transformReply: {
            2(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply2<BlobStringReply<string>>, _: any, typeMapping?: TypeMapping | undefined): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: number;
                };
            }>;
            3(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply3<BlobStringReply<string>>): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                };
            }>;
        };
    };
    readonly mGetWithLabels: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument, options?: import("./MGET_WITHLABELS").TsMGetWithLabelsOptions | undefined) => void;
        readonly transformReply: {
            2(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply2<BlobStringReply<string>>, _: any, typeMapping?: TypeMapping | undefined): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: number;
                };
            }>;
            3(this: void, reply: import("./MGET_WITHLABELS").MGetLabelsRawReply3<BlobStringReply<string>>): MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sample: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                };
            }>;
        };
    };
    readonly MGET: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument, options?: import("./MGET").TsMGetOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MGET").MGetRawReply2, _: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                sample: {
                    timestamp: NumberReply<number>;
                    value: number;
                };
            }>;
            readonly 3: (this: void, reply: import("./MGET").MGetRawReply3) => MapReply<BlobStringReply<string>, {
                sample: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                };
            }>;
        };
    };
    readonly mGet: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument, options?: import("./MGET").TsMGetOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MGET").MGetRawReply2, _: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                sample: {
                    timestamp: NumberReply<number>;
                    value: number;
                };
            }>;
            readonly 3: (this: void, reply: import("./MGET").MGetRawReply3) => MapReply<BlobStringReply<string>, {
                sample: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                };
            }>;
        };
    };
    readonly MRANGE_GROUPBY: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRangeGroupBy: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MRANGE_SELECTED_LABELS_GROUPBY: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRangeSelectedLabelsGroupBy: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MRANGE_SELECTED_LABELS: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: never;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRangeSelectedLabels: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: never;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MRANGE_WITHLABELS_GROUPBY: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: string[] | Buffer[];
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRangeWithLabelsGroupBy: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: string[] | Buffer[];
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MRANGE_WITHLABELS: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: Record<string, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRangeWithLabels: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: Record<string, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MRANGE: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE").TsMRangeRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: number;
            }[]>;
            readonly 3: (this: void, reply: import("./MRANGE").TsMRangeRawReply3) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[]>;
        };
    };
    readonly mRange: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE").TsMRangeRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: number;
            }[]>;
            readonly 3: (this: void, reply: import("./MRANGE").TsMRangeRawReply3) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[]>;
        };
    };
    readonly MREVRANGE_GROUPBY: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRevRangeGroupBy: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_GROUPBY").TsMRangeGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MREVRANGE_SELECTED_LABELS_GROUPBY: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRevRangeSelectedLabelsGroupBy: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MREVRANGE_SELECTED_LABELS: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: never;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRevRangeSelectedLabels: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, selectedLabels: RedisVariadicArgument, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, NullReply | BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_SELECTED_LABELS").TsMRangeSelectedLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: never;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MREVRANGE_WITHLABELS_GROUPBY: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: string[] | Buffer[];
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRevRangeWithLabelsGroupBy: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, groupBy: import("./MRANGE_GROUPBY").TsMRangeGroupBy, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: string[] | Buffer[];
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS_GROUPBY").TsMRangeWithLabelsGroupByRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                sources: ArrayReply<BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MREVRANGE_WITHLABELS: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: Record<string, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly mRevRangeWithLabels: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                labels: Record<string, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: number;
                }[];
            }>;
            readonly 3: (this: void, reply: import("./MRANGE_WITHLABELS").TsMRangeWithLabelsRawReply3) => MapReply<BlobStringReply<string>, {
                labels: MapReply<BlobStringReply<string>, BlobStringReply<string>>;
                samples: {
                    timestamp: NumberReply<number>;
                    value: DoubleReply<number>;
                }[];
            }>;
        };
    };
    readonly MREVRANGE: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE").TsMRangeRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: number;
            }[]>;
            readonly 3: (this: void, reply: import("./MRANGE").TsMRangeRawReply3) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[]>;
        };
    };
    readonly mRevRange: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: import("./MRANGE").TsMRangeRawReply2, _?: any, typeMapping?: TypeMapping | undefined) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: number;
            }[]>;
            readonly 3: (this: void, reply: import("./MRANGE").TsMRangeRawReply3) => MapReply<BlobStringReply<string>, {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[]>;
        };
    };
    readonly QUERYINDEX: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument) => void;
        readonly transformReply: {
            readonly 2: () => ArrayReply<BlobStringReply<string>>;
            readonly 3: () => import("@redis/client/dist/lib/RESP/types").SetReply<BlobStringReply<string>>;
        };
    };
    readonly queryIndex: {
        readonly NOT_KEYED_COMMAND: true;
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, filter: RedisVariadicArgument) => void;
        readonly transformReply: {
            readonly 2: () => ArrayReply<BlobStringReply<string>>;
            readonly 3: () => import("@redis/client/dist/lib/RESP/types").SetReply<BlobStringReply<string>>;
        };
    };
    readonly RANGE: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, fromTimestamp: Timestamp, toTimestamp: Timestamp, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: RespType<42, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[], never, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[]>) => {
                timestamp: NumberReply<number>;
                value: number;
            }[];
            readonly 3: (this: void, reply: SamplesRawReply) => {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[];
        };
    };
    readonly range: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, fromTimestamp: Timestamp, toTimestamp: Timestamp, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: RespType<42, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[], never, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[]>) => {
                timestamp: NumberReply<number>;
                value: number;
            }[];
            readonly 3: (this: void, reply: SamplesRawReply) => {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[];
        };
    };
    readonly REVRANGE: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, fromTimestamp: Timestamp, toTimestamp: Timestamp, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: RespType<42, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[], never, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[]>) => {
                timestamp: NumberReply<number>;
                value: number;
            }[];
            readonly 3: (this: void, reply: SamplesRawReply) => {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[];
        };
    };
    readonly revRange: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, fromTimestamp: Timestamp, toTimestamp: Timestamp, options?: import("./RANGE").TsRangeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: (this: void, reply: RespType<42, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[], never, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[]>) => {
                timestamp: NumberReply<number>;
                value: number;
            }[];
            readonly 3: (this: void, reply: SamplesRawReply) => {
                timestamp: NumberReply<number>;
                value: DoubleReply<number>;
            }[];
        };
    };
};
export default _default;
export declare function parseIgnoreArgument(parser: CommandParser, ignore?: TsIgnoreOptions): void;
export declare function parseRetentionArgument(parser: CommandParser, retention?: number): void;
export declare const TIME_SERIES_ENCODING: {
    readonly COMPRESSED: "COMPRESSED";
    readonly UNCOMPRESSED: "UNCOMPRESSED";
};
export type TimeSeriesEncoding = typeof TIME_SERIES_ENCODING[keyof typeof TIME_SERIES_ENCODING];
export declare function parseEncodingArgument(parser: CommandParser, encoding?: TimeSeriesEncoding): void;
export declare function parseChunkSizeArgument(parser: CommandParser, chunkSize?: number): void;
export declare const TIME_SERIES_DUPLICATE_POLICIES: {
    readonly BLOCK: "BLOCK";
    readonly FIRST: "FIRST";
    readonly LAST: "LAST";
    readonly MIN: "MIN";
    readonly MAX: "MAX";
    readonly SUM: "SUM";
};
export type TimeSeriesDuplicatePolicies = typeof TIME_SERIES_DUPLICATE_POLICIES[keyof typeof TIME_SERIES_DUPLICATE_POLICIES];
export declare function parseDuplicatePolicy(parser: CommandParser, duplicatePolicy?: TimeSeriesDuplicatePolicies): void;
export type Timestamp = number | Date | string;
export declare function transformTimestampArgument(timestamp: Timestamp): string;
export type Labels = {
    [label: string]: string;
};
export declare function parseLabelsArgument(parser: CommandParser, labels?: Labels): void;
export type SampleRawReply = TuplesReply<[timestamp: NumberReply, value: DoubleReply]>;
export declare const transformSampleReply: {
    2(reply: RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>): {
        timestamp: NumberReply<number>;
        value: number;
    };
    3(reply: SampleRawReply): {
        timestamp: NumberReply<number>;
        value: DoubleReply<number>;
    };
};
export type SamplesRawReply = ArrayReply<SampleRawReply>;
export declare const transformSamplesReply: {
    2(reply: RespType<42, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[], never, RespType<42, [NumberReply<number>, BlobStringReply<string>], never, [NumberReply<number>, BlobStringReply<string>]>[]>): {
        timestamp: NumberReply<number>;
        value: number;
    }[];
    3(reply: SamplesRawReply): {
        timestamp: NumberReply<number>;
        value: DoubleReply<number>;
    }[];
};
export declare function resp2MapToValue<RAW_VALUE extends TuplesReply<[key: BlobStringReply, ...rest: Array<ReplyUnion>]>, TRANSFORMED>(wrappedReply: ArrayReply<RAW_VALUE>, parseFunc: (rawValue: UnwrapReply<RAW_VALUE>) => TRANSFORMED, typeMapping?: TypeMapping): MapReply<BlobStringReply, TRANSFORMED>;
export declare function resp3MapToValue<RAW_VALUE extends RespType<any, any, any, any>, // TODO: simplify types
TRANSFORMED>(wrappedReply: MapReply<BlobStringReply, RAW_VALUE>, parseFunc: (rawValue: UnwrapReply<RAW_VALUE>) => TRANSFORMED): MapReply<BlobStringReply, TRANSFORMED>;
export declare function parseSelectedLabelsArguments(parser: CommandParser, selectedLabels: RedisVariadicArgument): void;
export type RawLabelValue = BlobStringReply | NullReply;
export type RawLabels<T extends RawLabelValue> = ArrayReply<TuplesReply<[
    label: BlobStringReply,
    value: T
]>>;
export declare function transformRESP2Labels<T extends RawLabelValue>(labels: RawLabels<T>, typeMapping?: TypeMapping): MapReply<BlobStringReply, T>;
export declare function transformRESP2LabelsWithSources<T extends RawLabelValue>(labels: RawLabels<T>, typeMapping?: TypeMapping): {
    labels: MapReply<BlobStringReply<string>, T>;
    sources: string[] | Buffer[];
};
//# sourceMappingURL=index.d.ts.map