// Generated by CoffeeScript 1.12.7
(function() {
  var ConnectionStates, databases;

  ConnectionStates = {
    disconnected: 0,
    connected: 1,
    connecting: 2,
    disconnecting: 3
  };


  /*
  instantiate w/ mongoose instance to avoid duplicate copies.
  (e.g. breaks model creation when `npm link`ing)
   */

  module.exports = databases = function(mongoose) {
    if (mongoose == null) {
      throw new Error('Mongoose is a required argument for mongoose-connection-manager!');
    }
    return {
      connections: {},
      callbacks: [],
      logger: null,
      get: function(name) {
        return this.connections[name];
      },
      exists: function(name) {
        return this.connections[name] != null;
      },
      create: function(name, settings) {
        if (name == null) {
          throw new Error("Connection name must be provided");
        }
        if (settings == null) {
          throw new Error("Connection settings must be provided");
        }
        if (!settings.url) {
          throw new Error("Connection url must be provided");
        }
        if (settings.useDefault) {
          this.connections[name] = mongoose.connection;
        } else {
          this.connections[name] = mongoose.createConnection();
        }
        this.connections[name].settings = settings;
        return this.connections[name];
      },
      setLogger: function(newLogger) {
        return this.logger = newLogger;
      },
      connect: function(cb) {
        var connectTo, connection, name, ref, results;
        if (this.allConnected()) {
          return process.nextTick(cb);
        }
        if (cb != null) {
          this.callbacks.push(cb);
        }
        connectTo = (function(_this) {
          return function(name, settings) {
            var finishOrRetry, options, ref, url;
            url = settings.url;
            options = (ref = settings.options) != null ? ref : {};
            finishOrRetry = function(err, result) {
              var callback, ref1, ref2, results;
              if (err != null) {
                if ((ref1 = (ref2 = settings.logger) != null ? ref2 : _this.logger) != null) {
                  ref1.error(err, "Failed to connect to `" + name + "` database on startup - retrying in 5 sec");
                }
                return setTimeout((function() {
                  return connectTo(name, settings);
                }), 5000);
              } else if (_this.allConnected()) {
                results = [];
                while (callback = _this.callbacks.pop()) {
                  results.push(callback());
                }
                return results;
              }
            };
            return _this.connections[name].openUri(url, options, finishOrRetry);
          };
        })(this);
        ref = this.connections;
        results = [];
        for (name in ref) {
          connection = ref[name];
          switch (connection.readyState) {
            case ConnectionStates.disconnected:
              results.push(connectTo(name, connection.settings));
              break;
            case ConnectionStates.disconnecting:
              throw new Error("Called connect() before disconnect() has finished");
              break;
            default:
              results.push(void 0);
          }
        }
        return results;
      },
      allConnected: function() {
        return Object.keys(this.connections).every((function(_this) {
          return function(connection) {
            return _this.connections[connection].readyState === ConnectionStates.connected;
          };
        })(this));
      },
      disconnect: function(callback) {
        return mongoose.disconnect(callback);
      }
    };
  };

}).call(this);
